/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.OperationGroup;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.DefaultChangeTrackingSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OperationBuilder {
    private static final Logger log = LoggerFactory.getLogger(OperationBuilder.class);
    private static final boolean DEFAULT_USE_EXPLICIT_CHAINING = true;
    private static final boolean DEFAULT_USE_FEEDS_CHAINING = false;
    private final Superplan superplan;
    private boolean useExplicitChaining;
    private boolean useFeedsChaining;
    private final Set<Operation> ops;
    private final Multimap<GeneralizedOrderRequest, Operation> firstGorOps;
    private final Multimap<GeneralizedOrderRequest, Operation> lastGorOps;
    private final SetMultimap<GeneralizedOrderRequest, Operation> gorOps;
    private int garCount;
    private int id = 0;

    public OperationBuilder(Superplan superplan) {
        this.superplan = superplan;
        this.ops = DefaultChangeTrackingSet.create();
        this.gorOps = HashMultimap.create();
        this.firstGorOps = HashMultimap.create(superplan.getGors().size(), 1);
        this.lastGorOps = HashMultimap.create(superplan.getGors().size(), 1);
        this.useExplicitChaining = true;
        this.useFeedsChaining = false;
    }

    public boolean isUseExplicitChaining() {
        return this.useExplicitChaining;
    }

    public void setUseExplicitChaining(boolean useExplicitChaining) {
        this.useExplicitChaining = useExplicitChaining;
    }

    public boolean isUseFeedsChaining() {
        return this.useFeedsChaining;
    }

    public void setUseFeedsChaining(boolean useFeedsChaining) {
        this.useFeedsChaining = useFeedsChaining;
    }

    @VisibleForTesting
    protected Set<Operation> getGorOperations(GeneralizedOrderRequest gor) {
        return this.gorOps.get((Object)gor);
    }

    @VisibleForTesting
    protected Collection<Operation> getFirstGorOps() {
        return Collections.unmodifiableCollection(this.firstGorOps.values());
    }

    @VisibleForTesting
    protected Collection<Operation> getLastGorOps() {
        return Collections.unmodifiableCollection(this.lastGorOps.values());
    }

    public int getGarCount() {
        return this.garCount;
    }

    private void chainGorsExplicitly() {
        String RELEASED_BEFORE_PROPERTY = "released_before";
        ShopConfiguration conf = this.superplan.getShopConf();
        PropertyDefinition pd = conf.getPropertyDefinition(GeneralizedOrderRequest.class, "released_before");
        if (pd != null && pd.getType() == PropertyDefinition.PropertyType.STRING) {
            log.info("Using GOR ordering to setup inter-GOR dependencies.");
            int cnt = 0;
            for (Map.Entry<GeneralizedOrderRequest, Collection<Operation>> e : this.firstGorOps.asMap().entrySet()) {
                GeneralizedOrderRequest predGor = e.getKey();
                Collection<Operation> predOps = e.getValue();
                String propVal = Strings.nullToEmpty((String)predGor.getProperty(pd));
                for (String succId : Splitter.on(',').omitEmptyStrings().trimResults().split(propVal)) {
                    GeneralizedOrderRequest succGor = this.superplan.getGor(succId);
                    if (succGor != null) {
                        Collection<Operation> succOps = this.firstGorOps.get(succGor);
                        if (succOps != null && !succOps.isEmpty()) {
                            OperationBuilder.chainOps(predOps, succOps);
                            ++cnt;
                            continue;
                        }
                        log.warn("Cannot find any operation for GOR {} among current MoKoS operations (but it is in superplan). Referenced from {}.", (Object)succId, (Object)predGor.getId());
                        continue;
                    }
                    log.warn("Cannot find GOR {} in superplan. Referenced from {}.", (Object)succId, (Object)predGor.getId());
                }
            }
            log.debug("Setup {} inter-GOR dependencies.", (Object)cnt);
        }
    }

    private void chainGorsExplicitly2() {
        String FEEDS_PROPERTY = "feeds";
        ShopConfiguration conf = this.superplan.getShopConf();
        PropertyDefinition pd = conf.getPropertyDefinition(GeneralizedOrderRequest.class, "feeds");
        if (pd != null && pd.getType() == PropertyDefinition.PropertyType.STRING) {
            log.info("Using GORs' feeds property to setup inter-GOR dependencies.");
            int cnt = 0;
            for (Map.Entry<GeneralizedOrderRequest, Collection<Operation>> e : this.lastGorOps.asMap().entrySet()) {
                GeneralizedOrderRequest predGor = e.getKey();
                Collection<Operation> predOps = e.getValue();
                String propVal = Strings.nullToEmpty((String)predGor.getProperty(pd));
                for (String succId : Splitter.on(',').omitEmptyStrings().trimResults().split(propVal)) {
                    GeneralizedOrderRequest succGor = this.superplan.getGor(succId);
                    if (succGor != null) {
                        Collection<Operation> succOps = this.firstGorOps.get(succGor);
                        if (succOps != null && !succOps.isEmpty()) {
                            OperationBuilder.chainOps(predOps, succOps);
                            ++cnt;
                            continue;
                        }
                        log.warn("Cannot find any operation for GOR {} among current MoKoS operations (but it is in superplan). Referenced from {}.", (Object)succId, (Object)predGor.getId());
                        continue;
                    }
                    if (this.superplan.getCustomerRequest(succId) != null || conf.getMatprod(succId) != null) continue;
                    log.warn("Cannot find GOR/Cr/Mat {} in superplan. Referenced from {}.", (Object)succId, (Object)predGor.getId());
                }
            }
            log.info("Setup {} inter-GOR dependencies.", (Object)cnt);
        }
    }

    static void chainOps(Operation predOp, Operation succOp) {
        if (predOp.isGrouped() || succOp.isGrouped()) {
            Set<Object> succOps;
            Operation predOp2;
            if (predOp.isGrouped()) {
                List<Operation> predOps = predOp.getGroup().getOperations();
                predOp2 = predOps.get(predOps.size() - 1);
            } else {
                predOp2 = predOp;
            }
            if (succOp.isGrouped()) {
                succOps = Sets.newIdentityHashSet();
                succOps.addAll(succOp.getGroup().getOperations());
            } else {
                succOps = Collections.singleton(succOp);
            }
            for (Operation operation : succOps) {
                predOp2.addSuccessor(operation);
                operation.addPredecessor(predOp2);
            }
        } else {
            predOp.addSuccessor(succOp);
            succOp.addPredecessor(predOp);
        }
    }

    static void chainOps(Collection<Operation> predOps, Collection<Operation> succOps) {
        if (predOps.size() == 1 && succOps.size() == 1) {
            OperationBuilder.chainOps(predOps.iterator().next(), succOps.iterator().next());
        } else {
            for (Operation predOp : predOps) {
                for (Operation succOp : succOps) {
                    predOp.addSuccessor(succOp);
                    succOp.addPredecessor(predOp);
                }
            }
        }
    }

    public Set<Operation> build() {
        for (GeneralizedOrderRequest gor : this.superplan.getGorsToPlan()) {
            if (!gor.hasSelectedActiongram()) {
                gor.setActiongram(gor.getProduct().getDefaultActiongram());
            }
            this.createOpsForGor(gor);
        }
        if (this.useExplicitChaining) {
            this.chainGorsExplicitly();
        }
        if (this.useFeedsChaining) {
            this.chainGorsExplicitly2();
        }
        return this.ops;
    }

    private void createOpsForGor(GeneralizedOrderRequest gor) {
        List<GeneralizedActionRequest> gars = gor.getGars();
        ArrayList<Operation> lastOps = Lists.newArrayList();
        ArrayList<Operation> currentOps = Lists.newArrayList();
        Operation lastJoinedOp = null;
        OperationGroup group = null;
        boolean first = true;
        for (GeneralizedActionRequest gar : gars) {
            if (gar.getAmount() < 1.0E-7) {
                if (group == null || gar.getAction().isJoinedWithFollowing()) continue;
                group = null;
                lastOps.clear();
                lastOps.add(lastJoinedOp);
                continue;
            }
            ++this.garCount;
            if (gar.getAction().hasLocalAlts() && !gar.isActionLocked() && gar.getInPlanQty() <= 1.0E-7) {
                OperationGroup laGroup = new OperationGroup();
                for (Action action : gar.getAction().getLocalAlts()) {
                    Preconditions.checkState(!action.isJoinedWithFollowing() && group == null, "LAG cannot be part of opGroup");
                    Operation op = this.newOperation(gar, action);
                    laGroup.addOperation(op);
                    op.setLaGroup(laGroup);
                    currentOps.add(op);
                }
            } else {
                Iterator action = gar.getAction();
                Operation op = this.newOperation(gar, (Action)((Object)action));
                currentOps.add(op);
                if (((Action)((Object)action)).isJoinedWithFollowing() && group == null) {
                    group = new OperationGroup();
                }
                if (group != null) {
                    group.addOperation(op);
                    op.setGroup(group);
                }
                if (!((Action)((Object)action)).isJoinedWithFollowing()) {
                    group = null;
                } else {
                    lastJoinedOp = op;
                }
            }
            this.ops.addAll(currentOps);
            this.gorOps.putAll(gor, currentOps);
            if (first) {
                first = false;
                this.firstGorOps.putAll(gor, currentOps);
                for (Operation op : currentOps) {
                    op.setActiongramStart(true);
                }
            }
            for (Operation op : currentOps) {
                for (Operation predOp : lastOps) {
                    op.addPredecessor(predOp);
                    predOp.addSuccessor(op);
                }
            }
            if (!gar.getAction().isJoinedWithFollowing()) {
                ArrayList<Operation> tmp = lastOps;
                lastOps = currentOps;
                currentOps = tmp;
            }
            currentOps.clear();
        }
        if (!lastOps.isEmpty()) {
            this.lastGorOps.putAll(gor, lastOps);
        }
    }

    @Nonnull
    private Operation newOperation(GeneralizedActionRequest gar, Action action) {
        return new Operation(gar, action, this.id++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected String dumpGraph() {
        BufferedWriter w = null;
        String fn = "";
        try {
            File file = File.createTempFile("op-graph-", ".dot");
            fn = file.getAbsolutePath();
            System.out.println(file);
            w = Files.newWriter(file, Charset.forName("utf-8"));
            w.write("digraph operations {\n");
            IdentityHashMap<Operation, String> ids = Maps.newIdentityHashMap();
            Set<OperationGroup> groups = Sets.newIdentityHashSet();
            Set<OperationGroup> laGroups = Sets.newIdentityHashSet();
            int id = 1;
            for (Operation op : this.ops) {
                String sid = String.format("op%d", id++);
                ids.put(op, sid);
                if (op.isGrouped()) {
                    groups.add(op.getGroup());
                }
                if (!op.hasLag()) continue;
                laGroups.add(op.getLaGroup());
            }
            int groupId = 1;
            for (OperationGroup group : groups) {
                w.write(String.format("subgraph cluster%d{\n", groupId));
                w.write("color = blue;\n");
                w.write("node [style=filled];\n");
                for (Operation op : Lists.reverse(group.getOperations())) {
                    w.write((String)ids.get(op) + ";");
                }
                w.write("\n}\n");
                ++groupId;
            }
            for (OperationGroup group : laGroups) {
                w.write(String.format("subgraph cluster%d{\n", groupId));
                w.write("color = orange;\n");
                w.write("node [style=filled];\n");
                for (Operation op : Lists.reverse(group.getOperations())) {
                    w.write((String)ids.get(op) + ";");
                }
                w.write("\n}\n");
                ++groupId;
            }
            for (Operation op : this.ops) {
                String sid = (String)ids.get(op);
                for (Operation predOp : op.getPredecessors()) {
                    w.write(sid + " -> " + (String)ids.get(predOp) + " [color=red,weight=0];\n");
                }
                for (Operation succOp : op.getSuccessors()) {
                    w.write(sid + " -> " + (String)ids.get(succOp) + " [color=green,weight=1];\n");
                }
            }
            for (Operation op : this.ops) {
                w.write((String)ids.get(op) + "[label=\"" + op + "\"];\n");
            }
            w.write("}\n");
            w.close();
        }
        catch (Exception e) {
            log.error("Error while dumping operation graph", e);
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException e) {
                    log.error("Error while dumping operation graph", e);
                }
            }
        }
        return fn;
    }

    @VisibleForTesting
    protected void debugGraph() {
        try {
            new ProcessBuilder("dotty", this.dumpGraph()).inheritIO().start();
        }
        catch (IOException e) {
            log.error("cannot launch dotty", e);
        }
    }
}

